# twitch_svclogs

The module allows easy access to the Cloudwatch Logs service leveraging milliner credentials on bare metal hostclasses and optionally leveraging pop to region mapping defined by the default_region facter fact. 

It can also be used on EC2 instances using EC2 instance auth roles. 

A legacy functionality selectively plugs into a handful of regions utilizing sandstorm credentials in the following accounts:
 - twitch-video
 - twitch-video-ops-stg
 - twitch-video-ops-aws
 - twitch-dumbodrop
 
This pattern is deprecated.

Each logfile object for baremetal usage is bound to the service account(s) and role they are tied to in milliner. However, the region of ingestion is configurable. 

# Usage
By default, a logfile will attempt to use milliner credentials on its baremetal tier and push logs to us-west-2.

To process the logfile '/var/log/jtv/foo.log':
```
twitch_svclogs::logfile { 'foo': }
```

Or the logfile '/var/log/boblog.log':
```
twitch_svclogs::logfile { 'boblog':
    log_dir => '/var/log'
}
```

If you want to use the pop to region mapping defined by default_region:
```
twitch_svclogs::logfile { 'foobar':
  use_default_region => true,
}
```

or simply enable it in twitch::service:
`   svclogs => true,`

Or to ingest logs using ec2 instance profile credentials (which doesn't need milliner):
```
twitch_svclogs::logfile { 'foobar':
    use_milliner => false,
    account      => 'instance-role'
}
```

## Result:
On puppet apply, the log group and/or log stream will be created, and log events will begin to be sent. 
That's all you need!

# Parameters
twitch_svclogs::logfile parameters:
```
    ensure:             (present)/absent  - create or remove the instance
    filename:           (${name}.log)     - filename of the logfile to watch
    log_dir:            (/var/log/jtv)    - directory the logfile lives in
    log_group_name:     (svclogs/$name)   - cloudwatch log group to send to
    log_stream_name:    ($pop/$hostname)  - log stream name in the log group
    buffer_duration:    (5000ms)          - how often to scan for new logs
    batch_size:         (32768 bytes)     - min size of batch to send
    batch_count:        (1000)            - lines in batch or something
    account:            (twitch-video)    - DEPRECATED: account to send logs into (only works for virtual resources defined in service.pp)
    region:             (us-west-2)       - Region to send logs into. May be optionally set for account or for use_milliner (if use_default_region is false)
    use_milliner:       (true)            - Source milliner creds to push to cloudwatch (When true, use in place of account)
    use_default_region: (false)           - Use the default_region fact to choose which AWS region the logs should be uploaded to. If false, it will use the value of region.
```


## Legacy Usage (DO NOT USE)

To ingest logs into another account (using sandstorm + predefined virtual resources):
```
twitch_svclogs::logfile { 'foobar':
    account => 'twitch-video-ops'
}
```

There are sandstorm secrets for each account/environment at:
 - video/twitch-video/(staging|production)/svclogs
 - video/twitch-video-ops/(staging|production)/svclogs
