# twitch_svclogs installation class
class twitch_svclogs::install (
    $ensure          = $::twitch_svclogs::ensure,
    $base_dir        = $::twitch_svclogs::base_dir,
    $runas_user      = $::twitch_svclogs::runas_user,
    $awslogs_version = $::twitch_svclogs::awslogs_version,
) inherits ::twitch_svclogs::params {

  $ensure_dir = $ensure ? {
    present => directory,
    absent  => absent,
    default => directory,
  }

  $_awslogs_version = $ensure ? {
    present => $awslogs_version,
    default => absent,
  }

  if ( $ensure == 'present' ) {
    include twitch_python::pip::awscli
    $cwlogs_require = Python::Pip['awscli']
  }

  python::pip { 'awscli-cwlogs':
    ensure  => $_awslogs_version,
    pkgname => 'awscli-cwlogs',
    require => $cwlogs_require,
  }

  file { $base_dir:
    ensure  => $ensure_dir,
    path    => $base_dir,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Python::Pip['awscli-cwlogs'],
  }

  # don't try to create 'root' as local user.
  if ( $runas_user != 'root' ) {
    if !defined(Twitch::Local_user[$runas_user]) {
      # create service user/group
      twitch::local_user { $runas_user:
        groups  => [ 'syslog', 'adm' ],
      }
    }
  }

}
