# twitch_svclogs::logfile instance type
define twitch_svclogs::logfile(
  $ensure             = present,
  $filename           = undef,
  $log_dir            = '/var/log/jtv',
  $log_group_name     = undef,
  $log_stream_name    = "${::pop}/${::hostname}",
  $datetime_format    = '%b %d %H:%M:%S',
  $buffer_duration    = 5000, # ms
  $batch_size         = 32768, # bytes
  $batch_count        = 1000,
  $account            = 'twitch-video',
  $region             = 'us-west-2',
  $use_milliner       = true,
  $use_default_region = false,
) {

  include ::twitch_svclogs
  $base_dir   = $twitch_svclogs::base_dir

  validate_bool(str2bool($use_milliner))

  if $use_default_region {
    $instance_region = $::default_region
  } else{
    $instance_region = $region
  }

  if str2bool($use_milliner) {
    $instance_name = "svclogs-milliner-${instance_region}"
  } else {
    $instance_name = "svclogs-${account}-${region}"
  }

  $config_dir = "${base_dir}/${instance_name}/conf.d"

  # Legacy pattern: not using milliner and using sandstorm.
  if (! $use_milliner) {
    include ::twitch_svclogs::service
    realize(::Twitch_svclogs::Service::Instance[$instance_name])
  } else {
    # Wrap in if statement to prevent duplicate declarations.
    if (! defined(Twitch_svclogs::Service::Instance["svclogs-milliner-${instance_region}"])) {
      ::twitch_svclogs::service::instance { "svclogs-milliner-${instance_region}":
        # This instance configures the daemontools service to source creds from
        # milliner (via the /etc/milliner-client-env.sh file placed on each bare metal instance)
        ensure             => $ensure,
        account            => 'instance-role',
        use_milliner       => true,
        region             => $instance_region, # TODO: cleanup and remove legacy usage pattern once all legacy consumers are decommed (usher)
        use_default_region => $use_default_region,
      }
    }
  }

  if ($filename) {
    validate_string($filename)
    $file = "${log_dir}/${filename}"
  } else {
    $file = "${log_dir}/${name}.log"
  }

  if ($log_group_name) {
    validate_string($log_group_name)
    $_log_group_name = $log_group_name
  } else {
    $_log_group_name = "svclogs/${name}"
  }

  # lets keep names consistent in template
  $_log_stream_name = $log_stream_name

  validate_string($log_dir)
  validate_string($log_stream_name)
  validate_string($datetime_format)
  validate_integer($buffer_duration)
  validate_integer($batch_size)
  validate_integer($batch_count)

  file { $name:
    ensure  => $ensure,
    path    => "${config_dir}/${name}.conf",
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch_svclogs/logfile.erb'),
    notify  => Daemontools::Supervise[$instance_name],
  }

}
