# twitch_svclogs service class
class twitch_svclogs::service (
    $ensure = $::twitch_svclogs::params::ensure,

) inherits ::twitch_svclogs::params {
  # These are legacy virutal resources that map specific region/accounts to built instances of svclogs (predominantly using sandstorm)
  # TODO: cleanup usage of these so that this entire pattern can be deprecated.

  @::twitch_svclogs::service::instance { 'svclogs-instance-role-us-west-2':
    ensure  => $ensure,
    region  => 'us-west-2',
    account => 'instance-role',
  }

  @::twitch_svclogs::service::instance { 'svclogs-instance-role-us-east-1':
    ensure  => $ensure,
    region  => 'us-east-1',
    account => 'instance-role',
  }

  @::twitch_svclogs::service::instance { 'svclogs-instance-role-us-east-2':
    ensure  => $ensure,
    region  => 'us-east-2',
    account => 'instance-role',
  }

  @::twitch_svclogs::service::instance { 'svclogs-instance-role-eu-west-1':
    ensure  => $ensure,
    region  => 'eu-west-1',
    account => 'instance-role',
  }

  @::twitch_svclogs::service::instance { 'svclogs-instance-role-eu-west-2':
    ensure  => $ensure,
    region  => 'eu-west-2',
    account => 'instance-role',
  }

  @::twitch_svclogs::service::instance { 'svclogs-instance-role-ap-southeast-1':
    ensure  => $ensure,
    region  => 'ap-southeast-1',
    account => 'instance-role',
  }

  @::twitch_svclogs::service::instance { 'svclogs-twitch-dumbodrop-us-west-2':
    # sandstorm key path chooses between prod and stg accounts
    # based on environment
    ensure  => $ensure,
    region  => 'us-west-2',
    account => 'twitch-dumbodrop',
    owner   => 'video-offnet',
  }

  @::twitch_svclogs::service::instance { 'svclogs-twitch-video-us-west-2':
    # sandstorm key path chooses between prod and stg accounts
    # based on environment
    ensure  => $ensure,
    region  => 'us-west-2',
    account => 'twitch-video',
  }

  @::twitch_svclogs::service::instance { 'svclogs-twitch-video-us-east-1':
    # sandstorm key path chooses between prod and stg accounts
    # based on environment
    ensure  => $ensure,
    region  => 'us-east-1',
    account => 'twitch-video',
  }

  @::twitch_svclogs::service::instance { 'svclogs-twitch-video-ops-us-west-2':
    # sandstorm key path chooses between prod and stg accounts
    # based on environment
    ensure  => $ensure,
    region  => 'us-west-2',
    account => 'twitch-video-ops',
  }

  @::twitch_svclogs::service::instance { 'svclogs-twitch-video-ops-us-east-1':
    # sandstorm key path chooses between prod and stg accounts
    # based on environment
    ensure  => $ensure,
    region  => 'us-east-1',
    account => 'twitch-video-ops',
  }

}
