# twitch_syslog::central_syslog
#
# Twitch central syslog sender
#
# @example Specifying a central syslog host
#   classes:
#     - twitch_syslog::central_syslog
#
#   twitch_syslog::central_syslog::ingest_host: systems-team-syslog-ingress.dev.us-west2.justin.tv
#
# @param ingest_host [String] The hostname of the central syslog host (required)
# @param ingest_port [String] The port of the central syslog host (tcp + jsonl receiver, defaults to 7777)
# @param min_priority [String] The minimum priority to send to central logging (defaults to warn)
class twitch_syslog::central_syslog(
  $ingest_host  = undef,
  $ingest_port  = '7777',
  $min_priority = 'warn',
) {

  if $ingest_host == undef or $ingest_host == '' {
    $ensure = 'absent'
  } else {
    $ensure = 'file'
    if !($min_priority in ['debug', 'info', 'notice', 'warning', 'warn', 'err', 'error', 'crit', 'alert', 'emerg', 'panic']) {
      fail('min_priority is invalid')
    }
  }

  file { '/etc/rsyslog.d/43-jtv-ship-to-central.conf':
    ensure  => $ensure,
    content => template("${module_name}/43-jtv-ship-to-central.conf.erb"),
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    notify  => Service['rsyslog'],
  }
}
