# twitch_syslog params class
class twitch_syslog::params{
  $rsyslog_run_user             = 'syslog'
  $rsyslog_run_group            = 'syslog'
  $rsyslog_log_user             = 'syslog'
  $rsyslog_log_group            = 'adm'
  $rsyslog_perm_file            = '0644'
  $rsyslog_perm_dir             = '0755'
  $rsyslog_repeatedmsgreduction = 'off'
  $rsyslog_umask                = '0022'
  $relp_package_name            = false # to not install rsyslog-relp see ::rsyslog::install
  $gnutls_package_name          = false # to not install rsyslog-gnutls see ::rsyslog::install
  $rsyslog_rotate               = 3
  $rsyslog_udpserveraddress     = '127.0.0.1'
  $rsyslog_udpserverport        = 514
  $rsyslog_reopen_logs_command  = 'service rsyslog rotate'
  $rsyslog_omit_local_logging   = false
  $rsyslog_package_status       = 'installed'
  $rsyslog_local_loglevel       = 7
  $rsyslog_imjournalrun         = false
  $rsyslog_purge_rsyslogd       = true
  $rsyslog_max_message_size     = '16k'

  # Purge out files that have not been removed in X days
  # This is sometimes needed when an application generates unique log file names per event
  $log_archive_purge_days       = 30

  # Days worth of /var/log/syslog backups to keep in /var/log/archive.
  $syslog_retention_days        = 7

  $rsyslog_modules = [
    '# provides kernel logging support (previously done by rklogd)',
    'module(load="imklog")',
    '# provides UDP syslog reception',
    'module(load="imudp")',
  ]

  $rsyslog_escapecontrolcharactersonreceive = 'off'
  $rsyslog_system_log_rate_limit_interval   = '0'
  $rsyslog_system_log_rate_limit_burst      = '200'

  $local3_ingest_server = undef
  $var_log_group = 'syslog'
}
