# === Define: twitch_systemd::unit_file
#
#   Places a unit file in the correct location.
#   Glorified file{} resource. ;)
#
# === Parameters
#
# [*ensure*] (file/absent)
#   Create unit file, or delete unit file.
#
# [*path*] (string)
#   Where the unit file will be placed. Default: /etc/systemd/system
#   Another valid option may be /lib/systemd/system
#   The default comes from systemd::service define.
#
# [*content*] (string)
#   Must provide content OR source for unit file contents.
#   Content should be data, such as from template().
#
# [*source*] (string)
#   Must provide content OR source for unit file contents.
#   Source should probably be a puppet:/// path.
#
define twitch_systemd::unit_file (
  $ensure  = file,
  $path    = '/etc/systemd/system',
  $content = undef,
  $source  = undef,
) {
  include ::systemd

  validate_re($ensure, '^(present|file|absent)$')
  validate_re($name, '\.(service|slice|socket|timer|mount|target|path|automount|device|scope|swap)$')
  validate_string($content,$source,$path)

  file { "${path}/${name}":
    ensure  => $ensure,
    content => $content,
    source  => $source,
    owner   => 'root',
    group   => 'root',
    mode    => '0444',
    notify  => Class['::systemd'],
  }
}
