# twitch_teamd

#### Table of Contents
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Overview

- [Overview](#overview)
- [Module Description](#module-description)
- [Setup](#setup)
  - [What twitch_teamd affects](#what-twitch_teamd-affects)
  - [Beginning with twitch_teamd](#beginning-with-twitch_teamd)
- [Usage](#usage)
  - [Class twitch_teamd parameters](#class-twitch_teamd-parameters)
- [Reference](#reference)
  - [Classes](#classes)
  - [Defines](#defines)
- [Limitations](#limitations)
- [Contribution](#contribution)
  - [Making Changes](#making-changes)
  - [Pull Requests](#pull-requests)
  - [Code Reviews](#code-reviews)
- [Release Notes/Contributors/Etc **Optional**](#release-notescontributorsetc-optional)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
## Overview

Manages teamd network config

## Module Description

This module configures link aggregation and service for libteam. Team driver project (libteam.org)
is similar in functionality as the bonding driver but with added advantages and performance.

## Setup

### What twitch_teamd affects

* teamd packages
* /usr/local/bin/network-online
* team-wait-online service
* teamd service
* /etc/network/interfaces.d/team0.cfg
* /usr/local/bin/teamd_add_ports.py
* /usr/local/bin/teamd_generate_config.py
* /usr/local/bin/teamd_wait.sh
* teamd-confgen service
* teamd-portadd service
* team-wait-online service

### Beginning with twitch_teamd

## Usage

```puppet
include twitch_teamd

class { 'twitch_teamd': }

```

### Class twitch_teamd parameters

* twitch_teamd
  * version
  * timeout
  * aliases
  * method

## Reference

#### Class: twitch_teamd

##### Parameters

* `runner`: Select link aggregation mode for team interface. Valid options are "broadcast", "roundrobin", "activebackup", "loadbalance" and "lacp". "lacp" is the default.

### Classes

* twitch_teamd
* twitch_teamd::v1::config
* twitch_teamd::v1::install
* twitch_teamd::v1::service
* twitch_teamd::v2::config
* twitch_teamd::v2::install
* twitch_teamd::v2::service

### Defines
* none

## Limitations

Currently we rely on `$::interfaces_with_link`, which returns physical NICs that have links. This means that if a link were to go down, `teamd.conf` will be edited to only have the interface with the link.

## Contribution

### Making Changes

Contributions to this repository:

* need to be limited to what is described in [Module Description](#module-description).
  * Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module).
* should be reviewed via [Pull Requests](#pull-requests) before merging.
* must follow the [Code Contribution Guidelines].
* See the [Code Contribution Checklist] for a quick reference.
* Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

### Pull Requests
All pull requests must:
  - Have a description explaining the problem
  - Snippet of any output error
  - Snippet of any output showing the fixed results
  - Contain a link to a JIRA ticket
  - Have been linted:
   - `puppet-lint`
   - `flake8`
   - `puppet validate`
   - etc
  - Not contain lint errors. Run all new code through `puppet-lint`.

### Code Reviews

PR reviews require video core services approval before merging. If you need help finding a reviewer, ping the [#video-coreservices] Slack channel.

Contributions need to be limited to what is described in Module Description. Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module). Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

## Release Notes/Contributors/Etc **Optional**

[#video-coreservices]: https://twitch.slack.com/messages/CEVFAMMLH/
[Code Contribution Guidelines]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform
[Code Contribution Checklist]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform#PuppetUsageGuidanceVideoPlatform-GeneralGuidance
