#!/bin/sh
#
# designed to sit and wait for team0 to get an interface.
# much like NetworkManager-wait-online, minus the overhead

set -e

VERBOSE=false

usage() { echo "Usage: $0 [-v] TEAM_INTF">&2; exit 1; }
log() { if [ "$VERBOSE" = true ]; then echo "$1"; fi; }
get_ip_addr() {
  ip addr show $INTF 2>/dev/null | grep -oP 'inet \K([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)'
}


while getopts ":vt:" o; do
  case "${o}" in
    v)
      VERBOSE=true
      ;;
    *)
      usage
      ;;
  esac
done
shift $((OPTIND-1))

INTF=$1
[ -z "$INTF" ] && usage

while ! get_ip_addr >/dev/null; do
  sleep 1
done
log "$INTF has address $(get_ip_addr)"
