#!/usr/bin/python3
import json


def mac_address():
    with open('/proc/cmdline') as f:
        params = f.read().split()

    for param in params:
        if 'BOOTIF' in param:
            mac_list = param.split('-')[1:]
            return ':'.join(mac_list)


system_vendor = open('/sys/class/dmi/id/sys_vendor').read().strip().lower()
team_name = 'team0'
mac_address = mac_address()

team_type = {
            'activebackup': {
              "name": "activebackup"
            },
            'lacp': {
              "name": "lacp",
              "active": True,
              "fast_rate": True,
              "tx_hash": [
                  "l3",
                  "l4"
                  ]
              }
            }

if 'kontron' in system_vendor:
    runner = team_type['activebackup']
elif 'innotek' in system_vendor:
    runner = team_type['activebackup']
elif 'qemu' in system_vendor:
    runner = team_type['activebackup']
else:
    runner = team_type['lacp']

teamd_conf = {
  "device": team_name,
  "hwaddr": mac_address,
  "runner": runner,
  "link_watch": {"name": "ethtool"}
}

with open('/etc/teamd.conf', 'w') as teamd_conf_filename:
    json.dump(teamd_conf, teamd_conf_filename, indent=2)
