# twitch_teamd::v1::config
#
class twitch_teamd::v1::config {

  include ::twitch_teamd

  $interfaces_for_team = split($::interfaces_with_link,',')
  $lacp_macaddress     = pick($::macaddress_team0, $::macaddress_primary_25g, $::macaddress_primary_10g)
  $ifname              = $twitch_teamd::params::ifname
  $runner              = $twitch_teamd::params::runner
  $timeout             = $twitch_teamd::params::timeout

  validate_re($lacp_macaddress, '^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$')

  file { '/usr/local/bin/network-online':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/v1/network-online.sh",
  }

  file { '/etc/teamd.conf':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/v1/teamd.conf.erb"),
  }

  twitch_systemd::unit_file { 'team-wait-online.service':
    ensure  => 'present',
    content => template("${module_name}/v1/team-wait-online.service.erb"),
    require => File['/usr/local/bin/network-online'],
  }

  twitch_systemd::unit_file { 'teamd.service':
    ensure  => 'present',
    content => template("${module_name}/v1/teamd.service.erb"),
    require => File['/etc/teamd.conf'],
  }

}
