# Sets up a team'd interface and removes old-style bond0 configs.
# Also configures network aliases for a team interface.
#
class twitch_teamd::v1::service {
  include ::twitch_teamd

  $ifname = $twitch_teamd::params::ifname

  service {'teamd.service':
    ensure  => 'running',
    enable  => true,
    require => Twitch_systemd::Unit_file['teamd.service'],
  }

  service {'team-wait-online.service':
    ensure  => 'running',
    enable  => true,
    require => Twitch_systemd::Unit_file['team-wait-online.service'],
  }

  interfaces::interface { $twitch_teamd::ifname:
    ensure  => present,
    ifname  => $twitch_teamd::ifname,
    auto    => true,
    require => Service['teamd.service'],
  }

  interfaces::interface { 'bond0':
    ensure => absent,
  }

  $aliases_defaults = {
    auto   => true,
    method => 'static',
  }

  if !empty($twitch_teamd::aliases) {
    create_resources(interfaces::interface, $twitch_teamd::aliases, $aliases_defaults)
  }

}
