# twitch_teamd::v2::config
class twitch_teamd::v2::config {

  file { '/etc/network/interfaces.d/team0.cfg':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/v2/etc/network/interfaces.d/team0.cfg",
  }

  -> file { '/usr/local/bin/teamd_add_ports.py':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/v2/usr/local/bin/teamd_add_ports.py",
  }

  -> file { '/usr/local/bin/teamd_generate_config.py':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/v2/usr/local/bin/teamd_generate_config.py",
  }

  -> file { '/usr/local/bin/teamd_wait.sh':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/v2/usr/local/bin/teamd_wait.sh",
  }

  -> file { '/usr/local/bin/network-online':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/v2/usr/local/bin/network-online.sh",
  }

}
