# twitch_teamd::v2::service
class twitch_teamd::v2::service {

  systemd::service {'teamd-confgen':
    description  => 'Team Daemon configuration generator',
    before_units => ['teamd.service'],
    execstart    => '/usr/local/bin/teamd_generate_config.py',
    type         => 'oneshot',
    require      => File['/usr/local/bin/teamd_generate_config.py'],
  }

  -> service {'teamd-confgen':
    enable => true,
  }

  systemd::service {'teamd-portadd':
    description  => 'Add physical interfaces to teamd onboot',
    before_units => ['network-pre.target'],
    after_units  => ['teamd.service'],
    execstart    => '/usr/local/bin/teamd_add_ports.py',
    type         => 'simple',
    restart      => 'on-failure',
    restart_sec  => '2',
    require      => File['/usr/local/bin/teamd_add_ports.py'],
  }

  -> service {'teamd-portadd':
    enable => true,
  }

  systemd::service {'teamd':
    description   => 'Team Daemon',
    before_units  => ['network-pre.target'],
    wants         => ['network-pre.target'],
    execstart     => '/usr/bin/teamd -f /etc/teamd.conf -o -r',
    execstartpost => '/usr/local/bin/teamd_wait.sh',
    execstop      => '/usr/bin/teamd -k',
    restart       => 'always',
    require       => File['/usr/local/bin/teamd_wait.sh'],
  }

  -> service {'teamd':
    enable   => true,
  }

  systemd::service { 'team-wait-online':
    description       => 'Twitch Teaming Wait Online',
    before_units      => ['network-online.target'],
    after_units       => ['teamd.service'],
    execstart         => '/usr/local/bin/network-online -v team0',
    type              => 'oneshot',
    user              => 'nobody',
    wantedby          => ['network-online.target'],
    remain_after_exit => true,
  }

  -> service {'team-wait-online':
    enable => true,
  }

}
