require 'spec_helper'

# twitch_teamd subclasses inherits from base class, so we test as a whole unit
describe 'twitch_teamd' do
  let(:facts) { {
    :interfaces_with_link => 'enp0s8,enp0s3',
    :macaddress_team0 => '69:30:F7:EB:13:40',
    :macaddress_primary_10g => '69:30:F7:EB:13:40',
    :osfamily => 'Debian',
    :operatingsystem => 'Ubuntu',
    :operatingsystemrelease => '16.04',
    :puppetversion => '3.8.7',
    :rubyversion => '2.7.7',
  } }

  context 'with default values for all parameters' do
    # twitch_teamd
    it { should contain_class('twitch_teamd') }
    it { should contain_class('twitch_teamd::install').that_comes_before('Class[twitch_teamd::config]') }
    it { should contain_class('twitch_teamd::config').that_comes_before('Class[twitch_teamd::service]') }
    it { should contain_class('twitch_teamd::service').that_requires('Class[twitch_teamd::config]') }

    # twitch_teamd::install
    it { should contain_package('libteam-utils').with_ensure('present') }
    it { should contain_package('libteam5').with_ensure('present') }
    it { should contain_package('libteamdctl0').with_ensure('present') }

    # twitch_teamd::config
    it { should contain_file('/etc/teamd.conf').with({'ensure' => 'present', 'mode' => '0644', 'owner' => 'root', 'group' => 'root'}) }
    it { should contain_twitch_systemd__unit_file('teamd.service').with_ensure('present').that_requires('File[/etc/teamd.conf]') }

    # twitch_teamd::service
    it { should contain_service('teamd.service').with({'ensure' => 'running', 'enable' => true}) }
    it { should contain_interfaces__interface('team0').with({'ensure' => 'present', 'auto' => true}).that_requires('Service[teamd.service]') }
    it { should contain_interfaces__interface('bond0').with_ensure('absent') }
  end

  context 'with version pinned for libteam' do
    let(:params) { {'version' => '1.28-1twitch1'} }

    # twitch_teamd::install
    it { should contain_package('libteam-utils').with_ensure('1.28-1twitch1') }
    it { should contain_package('libteam5').with_ensure('1.28-1twitch1') }
    it { should contain_package('libteamdctl0').with_ensure('1.28-1twitch1') }
  end

end
