# twitch_telegraf
class twitch_telegraf {
  apt::source { 'influxdata':
    comment      => 'Mirror for InfluxData packages',
    location     => 'http://packages.internal.justin.tv/artifactory/vr-telegraf/',
    release      => $::lsbdistcodename,
    repos        => 'stable',
    architecture => 'amd64',
  }

  class { 'telegraf':
    require        => Apt::Source['influxdata'],
    manage_service => false,
    manage_repo    => false,
    inputs         => {
      'cpu'           => {
        'percpu'   => true,
        'totalcpu' => true,
      },
      'mem'           => {},
      'disk'          => {
        'ignore_fs' => ['devtmpfs', 'devfs', 'iso9660', 'overlay', 'aufs', 'squashfs'],
      },
      'diskio'        => {},
      'kernel'        => {},
      'processes'     => {},
      'swap'          => {},
      'system'        => {},
      'kernel_vmstat' => {},
      'net'           => {},
      'net_response'  => {},
      'puppetagent'   => {},
    },
    outputs        => {
      'graphite' => {
        'servers'  => ['graphite.internal.justin.tv:2003'],
        'prefix'   => 'servers',
        'template' => 'host.tags.measurement.field',
      }
    }
  }

  -> exec { 'rm-init.d-telegraf':
    command => '/bin/rm -f /etc/init.d/telegraf',
  }

  -> exec { 'install-telegraf-unit':
    command => '/bin/cp /usr/lib/telegraf/scripts/telegraf.service /lib/systemd/system/telegraf.service',
  }

  -> service { 'telegraf':
    enable => true,
  }
}
