# installs and configures tftpd-hpa
class twitch_tftpd (
  $force_removal = false,
) {
  # the $force_removal flag allows this module to clean up after itself
  if $force_removal {
    $package_ensure = 'absent'
    $file_ensure    = 'absent'
    $service_ensure = 'stopped'
  } else {
    $package_ensure = 'installed'
    $file_ensure    = 'present'
    $service_ensure = 'running'
  }

  package { 'tftpd-hpa':
    ensure => $package_ensure,
  }

  file { '/etc/default/tftpd-hpa':
    ensure  => $file_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/tftpd-hpa",
    require => Package['tftpd-hpa'],
    notify  => Service['tftpd-hpa'],
  }

  service { 'tftpd-hpa':
    ensure     => $service_ensure,
    hasrestart => true,
    hasstatus  => true,
    require    => File['/etc/default/tftpd-hpa'],
  }
}
