class twitch_tls_rotation (
  $force_removal = false,
) {
  if $force_removal {
    $file_ensure    = 'absent'
  } else {
    $file_ensure    = 'present'
  }

  package { 'sandstorm':
    ensure => present,
  }

  package { 'libwww-perl':
    ensure => present,
  }

  file { '/usr/local/bin/rotate-tls-session-keys.pl':
    ensure => $file_ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/rotate-tls-session-keys.pl",
  }

  twitch_cron { 'rotate-tls-session-keys-cron':
    ensure  => 'present',
    command => '/usr/local/bin/rotate-tls-session-keys.pl 2>&1 | /usr/bin/logger -p local3.info -t rotate-tls-session-keys-cron',
    user    => 'root',
    hour    => 13,
    minute  => 05,
  }

}
