# twitch_transcode

#### Table of Contents

1. [Description](#description)
1. [Setup - The basics of getting started with twitch_transcode](#setup)
    * [What twitch_transcode affects](#what-twitch_transcode-affects)
    * [Setup requirements](#setup-requirements)
    * [Beginning with twitch_transcode](#beginning-with-twitch_transcode)
1. [Usage - Configuration options and additional functionality](#usage)
1. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
1. [Limitations - OS compatibility, etc.](#limitations)
1. [Development - Guide for contributing to the module](#development)

## Description

This module is used to setup the generic transcoding services. More specific varieties are split off in other modules and called from here as needed.

## Setup

### Beginning with twitch_transcode

* Make sure sites.pp points the host at the transcode hiera cluster
* Hiera should send it to the transcode class

## Usage

* Customize a new transcode type by adding a new class def for it in this Module (no more module sprawl please)
* Edit existing transcode classes to update existing transcode setups, note that this would likely update running hosts (BE CAREFUL)

## Reference

Classes:
* ::twitch_transcode
* ::twitch_transcode::vp9
* ::twitch_transcode::vp9::apt
* ::twitch_transcode::vp9::install
* ::twitch_transcode::vp9::params

## Limitations

It is expected this will only be installed on transcoder hardware, some of which is very sepcialized

## Development

Develop new trancoder models as sub-modules of this one. See the vp9 dir for examples

