#!/usr/bin/env python3

from subprocess import Popen, PIPE, CalledProcessError
import re
import socket

SOURCE = "KontronGPU"
STATSD_HOST = "127.0.0.1"
STATSD_PORT = 8125

metrics_monitor_cmd = '''sudo env LD_LIBRARY_PATH=/opt/quicksync/libva/lib:/opt/quicksync/gmmlib/lib:/opt/quicksync/media-driver/lib:/opt/quicksync/mediasdk/lib:/opt/quicksync/mediasdk/share/mfx/samples \
LIBVA_DRIVERS_PATH=/opt/quicksync/media-driver/lib/dri \
LIBVA_DRIVER_NAME=iHD \
MFX_Home=/opt/quicksync/mediasdk \
/opt/quicksync/mediasdk/share/mfx/samples/metrics_monitor -p 1000 -s 1'''

script_cmd = "script -q /dev/null bash -c"

def main():
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    with Popen(script_cmd.split() + [metrics_monitor_cmd], stdout=PIPE, bufsize=1, universal_newlines=True) as p:
        for line in p.stdout:
            line_a = re.split('\t', line.strip().replace(',', '').replace(':', ''))
            for raw_metric in line_a:
                metric_name, metric_value = raw_metric.rsplit(' ', 1)
                metric_name = metric_name.replace(' ', '_')
                try:
                    metric_value = float(metric_value)
                except ValueError as ve:
                    continue
                # please see https://github.com/influxdata/telegraf/pull/3183/files for more details about the cloudwatch limits
                if metric_value > 0 and metric_value < 8.515920e-109:
                    metric_value = 0
                metric = f"{metric_name}:{metric_value}|g|#source:{SOURCE}"
                sock.sendto(metric.encode('ascii'), (STATSD_HOST, STATSD_PORT))

    if p.returncode != 0:
        raise CalledProcessError(p.returncode, p.args)

if __name__ == '__main__':
    try:
        main()
    except Exception as e:
        print(traceback.format_exc())
