# Class: twitch_transcode
# ===========================
#
# This is the entrypoint to setting up twitch transcoding stack
#
class twitch_transcode (
  $include_transcoder       = false,
  $include_transmuxer       = false,
  $include_event_transcoder = false,
  # VIDCS-2715 - Case is because all x2's and ev's are provisioned with these resources and accompanying haproxy backend
  $include_tenfoot    = $::lsbdistcodename ? {
    'xenial' => true,
    default  => false,
  },
  $stag_rotate        = true,
) {
  class { '::hlsorigin':
    include_transcoder       => $include_transcoder,
    include_transmuxer       => $include_transmuxer,
    include_event_transcoder => $include_event_transcoder,
    include_tenfoot          => $include_tenfoot,
    stag_rotate              => $stag_rotate,
  }

  class { '::video_origin':
    include_event_transcoder => false,
    include_transcoder       => $include_transcoder,
    include_transmuxer       => $include_transmuxer,
  }
}
