# Setup hourly log rotate for worker streams
class twitch_transcode::qs::logrotate {
  logrotate::rule { 'jtv_hls':
    ensure          => present,
    path            => [
      '/var/log/jtv/hls_*',
      '/var/log/jtv/twitchtranscoder_*',
    ],
    olddir          => '/var/log/archive',
    missingok       => true,
    rotate          => 72,
    rotate_every    => 'hour',
    compress        => true,
    compressoptions => '-1',
    sharedscripts   => true,
    create          => false,
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
    require         => File['/var/log/archive'],
  }

  logrotate::rule { 'jtv_origin':
    ensure          => present,
    path            => '/var/log/jtv/video-origin.log',
    olddir          => '/var/log/archive',
    missingok       => true,
    rotate          => 72,
    rotate_every    => 'hour',
    compress        => true,
    compressoptions => '-1',
    sharedscripts   => true,
    create          => false,
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
    require         => File['/var/log/archive'],
  }

  logrotate::rule { 'jtv_haproxy':
    ensure          => present,
    path            => '/var/log/jtv/haproxy_*',
    olddir          => '/var/log/archive',
    missingok       => true,
    rotate          => 72,
    rotate_every    => 'hour',
    compress        => true,
    compressoptions => '-1',
    sharedscripts   => true,
    create          => false,
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
    require         => File['/var/log/archive'],
  }
}
