# Monitoring config for transcode-qs
class twitch_transcode::qs::monitoring (
) {

  twitch_servicecheck::passive { 'puppet-agent':
    command  => '/usr/lib/nagios/plugins/check_file_age -w 3300 -c 6600 -f /var/lib/puppet/state/last_run_summary.yaml',
    user     => 'puppet',
    interval => 4,
  }

  twitch_servicecheck::passive { 'transcode haproxy backend':
    command  => '/usr/local/monitor_scripts/check_haproxy_backends.py',
    interval => 3,
  }

  twitch_servicecheck::passive { 'two-day-transcodes':
    command  => '/usr/local/monitor_scripts/check_process_age.sh',
    interval => 5,
  }

  twitch_servicecheck::passive { 'uptime':
    command => '/usr/local/monitor_scripts/check_uptime.py -w 600 -c 300',
  }

  file { '/usr/local/bin/metrics_monitor.py':
    ensure => 'file',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/metrics_monitor.py",
  }

  twitch_systemd::service { 'metrics_monitor':
    command   => '/usr/local/bin/metrics_monitor.py',
    user      => 'root',
    group     => 'root',
    timeout   => 5,
    subscribe => File['/usr/local/bin/metrics_monitor.py'],
  }
}
