# == Class: twitch_transcode::vp9::apt
#
# Add Apt repo for the IP VP9 Stable package
#

class twitch_transcode::vp9::apt (
  $twitch_apt_key               = $twitch_transcode::vp9::params::twitch_apt_key,
  $twitch_apt_key_uri           = $twitch_transcode::vp9::params::twitch_apt_key_uri,
  $twitch_apt_base_uri          = $twitch_transcode::vp9::params::twitch_apt_base_uri,
)  inherits ::twitch_transcode::vp9::params {

  apt::source { 'ip-vp9-stable-xenial':
    location     => "${twitch_apt_base_uri}/ip-vp9-stable-xenial",
    repos        => 'main',
    release      => 'custom',
    architecture => 'amd64',
    include      => {
      'src' => false
    },
    key          => {
      'id'     => $twitch_apt_key,
      'source' => $twitch_apt_key_uri,
    },
  }
}
