# Class: twitch_transcode::vp9::install
#
# installs the xilinx pkg and ipmitool

class twitch_transcode::vp9::install (
  $xilinx_ensure = $twitch_transcode::vp9::params::xilinx_ensure,
  $ensure_xpacd  = $twitch_transcode::vp9::params::ensure_xpacd,
  $enable_xpacd  = $twitch_transcode::vp9::params::enable_xpacd,
)  inherits ::twitch_transcode::vp9::params {
  include twitch_transcode::vp9::apt
  include twitch_ipmitool

  package { 'xilinx-core':
    ensure  => $xilinx_ensure,
    require => Class['twitch_transcode::vp9::apt'],
  }

  service { 'xpacd':
    ensure  => $ensure_xpacd,
    enable  => $enable_xpacd,
    require => Package['xilinx-core'],
  }

}
