# Class: twitch_transcode::vp9::monitoring
#
# installs the passive monitoring configuration

class twitch_transcode::vp9::monitoring inherits ::twitch_transcode::vp9::params {

  include twitch_nrdp

  twitch_nrdp::check { 'xilinx_aix_firewall':
    command        => '/opt/xilinx-infratools/share/nagios/xilinx_aix_firewall',
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'xilinx_fpga_temp':
    command        => '/opt/xilinx-infratools/share/nagios/xilinx_fpga_temp',
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'xilinx_ecctest':
    command        => '/opt/xilinx-infratools/share/nagios/xilinx_ecctest',
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  # Do not include DSA check for now as it cannot be run without harming the application
  # twitch_nrdp::check { 'xilinx_dsa':
  #   command        => '/opt/xilinx-infratools/share/nagios/xilinx_dsa',
  #   interval       => 10,
  #   retry          => 1,
  #   retry_interval => 5,
  # }
}
