# Math is taken from https://nlnetlabs.nl/documentation/unbound/howto-optimise/, which states:
#
#  Set *-slabs to a power of 2 close to the num-threads value.
#
Puppet::Parser::Functions.newfunction(:unbound_calculate_slabs, :type => :rvalue) do |args|
  if (args.size != 1) then
    raise(Puppet::ParseError, "unbound_calculate_slabs(): Wrong number of arguments "+
      "given #{arguments.size} for 1")
  end
  # Grab the only argument
  num = args.shift
  # Get the lowest power of 2 close to input
  2**(Math.log(num.to_i)/Math.log(2)).floor
end
