# bits to enable dnstap query logging
class twitch_unbound::dnstap (
  $ensure  = 'present',
  $version = 'latest',
  $syslog  = 'local3',
) inherits twitch_unbound::params {

  $socket  = '/var/tmp/dnstap.sock'

  $ensure_pkg = $ensure ? {
    'present' => $version,
    default   => 'absent',
  }

  $ensure_file = $ensure ? {
    'present' => 'file',
    default   => 'absent',
  }

  package { 'dnstap':
    ensure => $ensure_pkg,
  }

  daemontools::supervise { 'dnstap':
    ensure         => $ensure,
    wd             => '/var/run',
    daemon         => "/usr/local/bin/dnstap -u $socket",
    env            => 'production',
    syslog         => $syslog,
    user           => 'unbound',
    daemon_dir     => '/var/lib/service',
    manage_service => true,
    require        => Package['dnstap'],
  }

  file { "${twitch_unbound::params::unbound_confd_dir}/unbound_dnstap.conf":
    ensure  => $ensure_file,
    content => template('twitch_unbound/unbound_dnstap.conf.erb'),
    notify  => Service['unbound'],
  }
}
