# Setup filebeat for Unbound
class twitch_unbound::logging (
$dns_rsyslog = $twitch_unbound::params::dns_rsyslog,
  ) inherits twitch_unbound::params {

  if $dns_rsyslog {
    ::rsyslog::snippet{ '43-unbound':
      ensure  => 'present',
      content => template("${module_name}/rsyslog_unbound.erb")
    }
    logrotate::rule { 'unbound':
      ensure       => present,
      compress     => true,
      path         => '/var/log/unbound.log',
      missingok    => true,
      rotate       => '3',
      size         => '3G',
      rotate_every => 'hour',
      olddir       => '/var/log/archive',
      require      => File['/var/log/archive'],
      postrotate   => '/usr/local/bin/rsyslog_reopen_logs.sh',
    }
  }

  else {

    rsyslog::snippet { '43-unbound':
      ensure  => 'present',
      content => join([
        "if \$programname == 'unbound' then /var/log/unbound.log",
        '&~',
        ], "\n")
    }

    logrotate::rule { 'unbound':
      ensure       => present,
      path         => '/var/log/unbound.log',
      missingok    => true,
      olddir       => '/var/log/archive',
      rotate_every => 'day',
      rotate       => 7,
      require      => File['/var/log/archive'],
      postrotate   => '/usr/local/bin/rsyslog_reopen_logs.sh',
    }
  }
}
