# Params class for twitch_unbound
class twitch_unbound::params {

  case $::osfamily {
    'Debian': {
      $envfile = '/etc/default/unbound'
    }
    'RedHat': {
      $envfile = '/etc/sysconfig/unbound'
    }
    default: {
      fail('unsupported operating system')
    }
  }

  $role                        = undef
  # set num-threads to half of the number of processors by default
  $num_threads                 = $facts['processorcount'] / 2

  $interface                   = ''
  $remote_interface            = [ '127.0.0.1' ]

  $interface_automatic         = true
  $unbound_conf_dir            = '/etc/unbound'
  $unbound_confd_dir           = "${unbound_conf_dir}/twitch_conf.d"
  $unbound_key_dir             = "${unbound_conf_dir}/keys.d"
  $package_version             = '1.10.1-1build1.twitch1'
  $package_name                = 'unbound'
  $dns_rsyslog                 = false

  $route53_upstream            = [ '169.254.169.253' ]
  $video_route53_upstream      = [ '10.193.0.2' ]
  $video_dns_forwarders        = [ '10.193.2.134','10.193.2.252' ]

  $access_cidrs                = [ '127.0.0.0/8' ]
  $anycast_ipaddress           = undef
  $statistics_cumulative       = false
  $statistics_interval         = 0

  $zones                       = hiera('twitch_dns_zones')

  $default_custom_server_conf  = [  'so-sndbuf: 16m',
                                    'rrset-roundrobin: yes',
                                    'qname-minimisation: no',
                                    'log-servfail: yes']
  $custom_conf                 = [ "include: ${unbound_confd_dir}/*.conf" ]
  $val_permissive_mode         = false
  $val_log_level               = 0

  $vpc_resolver_domains        = ['amazonaws.com', 'cloudfront.net']

  $env                         = pick($twitch_environment,$::twitch_environment,'development')
  $enable_prefetch             = false
}
