# This is more a modernization of the code but this
# could use a real refactor.  This should probably be
# a define to make it callable multiple times. -MB
class twitch_unicorn (
  $web_env           = $twitch_unicorn::params::web_env,
  $consul_env        = $web_env,
  $rails_dir         = $twitch_unicorn::params::rails_dir,
  $unicorn_port      = $twitch_unicorn::params::unicorn_port,
  $user              = $twitch_unicorn::params::user,
  $syslog            = $twitch_unicorn::params::syslog,
  $envdir            = $twitch_unicorn::params::envdir,
  $worker_count      = $twitch_unicorn::params::worker_count,
  $in_api_stack      = $twitch_unicorn::params::in_api_stack,
  $in_www_stack      = $twitch_unicorn::params::in_www_stack,
  $is_canary         = $twitch_unicorn::params::is_canary
) inherits twitch_unicorn::params {
  validate_absolute_path($rails_dir)
  validate_string($rails_type)
  validate_string($user)
  validate_string($syslog)
  validate_re($worker_count, '^\d+$')

  include twitchtv

  daemontools::supervise { 'unicorn_rails':
    user      => $user,
    syslog    => $syslog,
    wd        => "${rails_dir}/current",
    daemon    => "envdir ${envdir} script/run_web_app",
    predaemon => [
      "source ${rails_dir}/current/config/unicorn_tuning.conf",
      "export NB_UNICORN_WORKERS=${worker_count}",
      "export staging=${staging}",
      'export LANG="en_US.UTF-8" LANGUAGE="en_US.UTF-8" LC_ALL="en_US.UTF-8"',
      'export PATH=/home/jtv/.rbenv/bin:/home/jtv/.rbenv/shims:$PATH RBENV_ROOT=/home/jtv/.rbenv/ HOME=/home/jtv',
      "export RAILS_ENV=${web_env}",
      "export RACK_ENV=${web_env}",
      'exec 2>&1'
    ],
    require   => [
      Class['twitchtv::app::secrets']
    ]
  }

  if $in_api_stack {
    $api_consul_tags = ["${twitchtv::consul_deploy_tag}-api"]
  } else {
    $api_consul_tags = []
  }

  if $in_www_stack {
    $www_consul_tags = ["${twitchtv::consul_deploy_tag}-www"]
  } else {
    $www_consul_tags = []
  }

  if $is_canary {
    $canary_consul_tags = ["${twitchtv::consul_deploy_tag}-canary"]
  } else {
    $canary_consul_tags = []
  }

  if $in_api_stack and $is_canary {
    $canary_api_consul_tags = ["${twitchtv::consul_deploy_tag}-canary-api"]
  } else {
    $canary_api_consul_tags = []
  }

  if $in_www_stack and $is_canary {
    $canary_www_consul_tags = ["${twitchtv::consul_deploy_tag}-canary-www"]
  } else {
    $canary_www_consul_tags = []
  }

  $consul_tags = [$twitchtv::consul_deploy_tag, $api_consul_tags, $www_consul_tags,
    $canary_consul_tags, $canary_api_consul_tags, $canary_www_consul_tags]

  consul::service { 'web-rails-app':
    port        => $unicorn_port,
    consul_tags => $consul_tags,
  }
}
