class twitch_unicorn::params {
  $envdir       = "/opt/twitch/web/etc/env"
  $web_env      = hiera('web_env', 'production')
  $rails_dir    = hiera('clean') ? {
                    'true' => "/opt/twitch/web",
                    default => hiera('rails_dir', '/opt/twitch/web'),
                  }
  $staging      = hiera('staging', false)
  $unicorn_port = 7000
  $user         = 'jtv'
  $syslog       = 'local3'

  $unicorn_package          = 'unicorn'
  $unicorn_package_ensure   = 'present'
  $unicorn_package_provider = 'gem'

  $worker_count = 60

  $in_api_stack = false
  $in_www_stack = true
  $is_canary = false
}
