# class twitch_useraccess::allowed_groups manages the /etc/allowed_groups file
class twitch_useraccess::allowed_groups(
  $allowed_groups = $twitch_useraccess::params::combined_allowed_groups
) inherits twitch_useraccess::params {
  validate_array($allowed_groups)

  file { '/etc/allowed_groups':
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/allowed_groups.erb"),
  }
}
