# install/apply auth-client-config ini
define twitch_useraccess::auth_client_config($profile) {

  $acc_profile_d        = '/etc/auth-client-config/profile.d'
  $acc_profile_filename = "${acc_profile_d}/${profile}"

  package {'auth-client-config':
    ensure => present,
  }

  file { $acc_profile_filename:
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/acc-${profile}.conf",
    require =>  Package['auth-client-config'],
  }

  exec { "/usr/sbin/auth-client-config -a -p ${profile}":
    unless  => "/usr/sbin/auth-client-config -s -a -p ${profile}",
    require => [Package['auth-client-config'],File[$acc_profile_filename]]
  }

}
