# class twitch_useraccess::login_defs
class twitch_useraccess::login_defs (
  $useradd_min_uid = $core::params::useradd_min_uid,
  $useradd_max_uid = $core::params::useradd_max_uid,
) inherits core {

  # default system locale
  file { '/etc/login.defs':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/login.defs.erb"),
    notify  => Exec['locale-gen']
  }

}
