# params for sudo, sudoers, access, allowed_groups
class twitch_useraccess::params {

  $libpam_ensure            = 'installed'
  $permanent_allowed_groups = $facts['twitch_environment'] ? {
    'dev'         => ['video-staging-access',],
    'development' => ['video-staging-access',],
    'staging'     => ['video-staging-access',],
    default       => ['video-ssh-access',],
  }

  $allowed_groups           = [] # our override class param
  $exclude_groups           = [] # we reject theses groups
  # hash of group_name     => sudoer spec
  # ex: infra_cool         => 'ALL=(ALL) NOPASSWD:ALL'
  $sudoers_groups           = {}

  validate_hash($sudoers_groups)

  # (perm_groups - exclude_groups) + override groups + sudoer group names
  $combined_allowed_groups = unique(concat(
    delete($permanent_allowed_groups, $exclude_groups),
    keys($sudoers_groups),
    $allowed_groups
  ))

  # since ldap_server is a more-global hiera value, it won't necessarily override in this module
  $ldap_server  = hiera('ldap_server','ldap-vip.internal.justin.tv')
  $ldap_min_uid = 10000
}
