# configure sssd
class twitch_useraccess::sssd_config (
  $ldap_server  = $twitch_useraccess::params::ldap_server,
  $ldap_min_uid = $twitch_useraccess::params::ldap_min_uid
) inherits twitch_useraccess::params {

  require twitch_useraccess

  class {'::twitch_sssd':
    config    => {
      'sssd'             => {
        'domains'             => 'justin.tv',
        'config_file_version' => 2,
        'services'            => ['nss', 'pam', 'ssh'],
      },
      'nss'              => {
        'filter_users'  => $::local_users,
        'filter_groups' => $::local_groups,
      },
      'domain/justin.tv' =>  {
        'id_provider'              => 'ldap',
        'auth_provider'            => 'ldap',
        'sudo_provider'            => 'none',
        'cache_credentials'        => true,
        'ldap_uri'                 => 'ldaps://ldap-ro.internal.justin.tv',
        'ldap_backup_uri'          => "ldaps://${ldap_server}",
        'ldap_search_base'         => 'dc=justin,dc=tv',
        'ldap_user_search_base'    => 'ou=Users,dc=justin,dc=tv?onelevel?',
        'ldap_group_search_base'   => 'ou=Groups,dc=justin,dc=tv?onelevel?',
        'ldap_id_use_start_tls'    => true,
        'ldap_tls_reqcert'         => 'demand',
        'ignore_group_members'     => true,
        'ldap_group_nesting_level' => 0,
        'ldap_tls_cacert'          => '/etc/ssl/certs/ca-certificates.crt',
        'ldap_schema'              => 'rfc2307bis',
        'ldap_group_member'        => 'uniqueMember',
        'min_id'                   => $ldap_min_uid,
        'refresh_expired_interval' => 4050 , # 3/4 * entry_cache_timeout (default = 5400)
        'debug_level'              => 0,
      }
    },
  }
  # refresh local_users and local_groups whenever whenever a package is installed in case new local users are created
  Package <| tag != 'virtual' and ensure != 'absent' |> ~> refacter { 'local_users_groups':   patterns => ['^local_*'],    }

}
