# class twitch_useraccess::sudoers
class twitch_useraccess::sudoers(
  $disable_common = false,
  $sudoers_groups = $twitch_useraccess::params::sudoers_groups,
) inherits twitch_useraccess::params {
  validate_bool($disable_common)

  # To create empty config files if no specific one is in files/
  $sudoer_source = "puppet:///modules/${module_name}/sudoers.d"

$access_group = $facts[twitch_environment] ? {
    'dev'         => 'video-staging-access',
    'development' => 'video-staging-access',
    'staging'     => 'video-staging-access',
    default       => 'video-sudo-access',
  }

  include ::sudo

  sudo::conf { 'ttv-inventory-agent':
    priority => 99,
  }

  sudo::conf { 'ttv-proxy-env':
    priority => 00,
    source   => "${sudoer_source}/defaults/env",
  }

  sudo::conf { 'ttv-team':
    priority => 05,
    content  => template("${module_name}/sudoers_ldap_groups.erb"),
  }

  unless $disable_common {
    sudo::conf { 'ttv-common':
      priority => 10,
      content  => template("${module_name}/common.erb"),
    }

    if ($::vagrant != undef) {
      sudo::conf { 'vagrant':
        priority => 99,
        source   => "${sudoer_source}/vagrant",
      }
    }

    # aws_bootstrap is a special fact we set when bootstrapping to do custom stuff
    # when building baseamis.
    if ($::aws_bootstrap != undef) {
      sudo::conf { 'aws-bootstrap':
        priority => 99,
        content  => 'ubuntu ALL=(ALL) NOPASSWD:ALL',
      }
    }
  }
}
