class twitch_usherproxy::config (
) inherits twitch_usherproxy {
  validate_hash($usher_proxies)

  $key_prefix                = 'video/usher-proxy/production/cert_usher_ttvnw_net'
  $restart_command = str2bool($::systemd) ? {
    true  => 'systemctl reload nginx',
    false => 'service nginx configtest && service nginx reload',
  }

  twitch_sandstorm_agent::template { 'usher_ttvnw_net_cert':
    destination     => '/etc/ssl/certs/usher_ttvnw_net.crt',
    mode            => '0644',
    owner           => 'root',
    group           => 'root',
    key             => "${key_prefix}/cert",
    restart_command => $restart_command,
  }

  twitch_sandstorm_agent::template { 'usher_ttvnw_net_key':
    destination     => '/etc/ssl/private/usher_ttvnw_net.key',
    mode            => '0640',
    owner           => 'root',
    group           => 'ssl-cert',
    key             => "${key_prefix}/key",
    restart_command => $restart_command,
  }

  twitch_sandstorm_agent::template { 'usher_ttvnw_net_dhparams':
    destination     => '/etc/ssl/private/usher_ttvnw_net.dhparams',
    mode            => '0640',
    owner           => 'root',
    group           => 'ssl-cert',
    key             => "${key_prefix}/dhparams",
    restart_command => $restart_command,
  }

  twitch_sandstorm_agent::template { 'usher_ttvnw_net_tls_key_current':
    destination     => '/etc/ssl/private/usher_ttvnw_net_tls_key_current',
    mode            => '0640',
    owner           => 'root',
    group           => 'ssl-cert',
    key             => "${key_prefix}/tls_key_current",
    restart_command => $restart_command,
    trim_newline    => true,
    require         => Twitch_sandstorm_agent::Template['usher_ttvnw_net_cert','usher_ttvnw_net_key','usher_ttvnw_net_dhparams'],
  }

  twitch_sandstorm_agent::template { 'usher_ttvnw_net_tls_key_previous':
    destination     => '/etc/ssl/private/usher_ttvnw_net_tls_key_previous',
    mode            => '0640',
    owner           => 'root',
    group           => 'ssl-cert',
    key             => "${key_prefix}/tls_key_previous",
    restart_command => $restart_command,
    trim_newline    => true,
    require         => Twitch_sandstorm_agent::Template['usher_ttvnw_net_cert','usher_ttvnw_net_key','usher_ttvnw_net_dhparams'],
  }

  twitch_sandstorm_agent::template { 'usher_ttvnw_net_tls_key_next':
    destination     => '/etc/ssl/private/usher_ttvnw_net_tls_key_next',
    mode            => '0640',
    owner           => 'root',
    group           => 'ssl-cert',
    key             => "${key_prefix}/tls_key_next",
    restart_command => $restart_command,
    trim_newline    => true,
    require         => Twitch_sandstorm_agent::Template['usher_ttvnw_net_cert','usher_ttvnw_net_key','usher_ttvnw_net_dhparams'],
  }

  # This installs Nagios passive checks onto servers that have secrets to monitor.
  realize(Twitch_nrdp::Check['check_sandstorm_agent','check_sandstorm_agent_ops'])

  # TODO: remove after we have this file nuked to change to sane convention
  file { '/usr/local/nginx/conf/servers/video-usherproxy.conf':
    ensure => 'absent',
  }

}
