class twitch_usherproxy (
  $usher_proxies = $twitch_usherproxy::params::usher_proxies,
  $proxies       = $twitch_usherproxy::params::proxies,
  $upstreams     = $twitch_usherproxy::params::upstreams,
) inherits twitch_usherproxy::params {
  # this module shouldn't load anything unless our FQDN is in this list
  if (member($proxies, $::fqdn) or ($cluster == 'usherweb') or ($cluster == 'video-service-ext') or ($cluster == 'usher-web')) {
    include twitch::crossdomain
    include twitch::robots
    anchor { 'twitch_usherproxy::begin': }
    -> class { 'twitch_usherproxy::config': }
    ~> class { 'twitch_usherproxy::service': }
    -> class { 'twitch_usherproxy::logrotate': }
    -> anchor { 'twitch_usherproxy::end': }
  }
}
