# This makes log rotate run hourly for usher.

class twitch_usherproxy::logrotate inherits twitch_usherproxy {

  logrotate::rule{ 'haproxy_usher':
    ensure          => absent,
    path            => '/var/log/jtv/haproxy_usher.log',
    missingok       => true,
    olddir          => '/var/log/archive/',
    rotate          => 12,
    rotate_every    => 'hourly',
    sharedscripts   => true,
    delaycompress   => true,
    compress        => true,
    compresscmd     => '/bin/gzip',
    compressoptions => '-1',
    compressext     => '.gz',
    create          => true,
    create_mode     => '0644',
    create_owner    => 'syslog',
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
  }

}
