class twitch_usherproxy::params {
  $proxies             = []
  $nrdp_folder         = '/usr/local/nrdp/checkcache'

  $nagios_service_name = 'usher proxy anycast'
  # usher proxy map
  case $cluster {
    'video-service-ext':  {
      $usher_proxies = {
        'lo:usher_proxy1' => {
          ipaddress       => '192.108.239.254',
        },
        'lo:usher_proxy2' => {
          ipaddress       => '23.160.0.254',
        },
      }
    }
    'usher-web':  {
      $usher_proxies = {
        'lo:usher_proxy1' => {
          ipaddress       => '192.108.239.254',
        },
        'lo:usher_proxy2' => {
          ipaddress       => '23.160.0.254',
        },
      }
    }
    default: {
      $usher_proxies = {
        'lo:usher_proxy5' => {
          ipaddress       => '192.108.239.254',
        },
        'lo:usher_proxy6' => {
          ipaddress       => '23.160.0.254',
        },
      }
    }
  }

  $upstreams = [
    'usher-web-835b6c.sjc02.justin.tv:8080',
    'usher-web-a36c4c.sjc02.justin.tv:8080',
    'usher-web-a24fcc.sjc02.justin.tv:8080',
    'usher-web-3d3a2a.sjc02.justin.tv:8080',
  ]
  $loopback_ensure = 'present'
  $bird_ensure     = 'present'
  $bird_usher_proxy_include = true
}
