class twitch_usherproxy::service (
  $loopback_ensure          = $twitch_usherproxy::params::loopback_ensure,
  $bird_ensure              = $twitch_usherproxy::params::bird_ensure,
  $bird_usher_proxy_include = $twitch_usherproxy::params::bird_usher_proxy_include
) inherits twitch_usherproxy {

  include bird

  # create IP loopbacks from usherproxy mappping
  create_resources(bird::loopback, $usher_proxies, {
    auto    => true,
    require => Twitch_nginx::Vhost['usherproxy'],
    ensure  => $loopback_ensure,
  })

  validate_hash($usher_proxies)

  twitch_nginx::vhost { 'usherproxy':
    content => template("${module_name}/nginx-usherproxy.conf.erb"),
  }

  # setup anycast health checks for usher proxies
  $ushers = keys($usher_proxies)

  twitch_anycast::health_enforcer::daemon { $ushers:
    health_url     => 'http://127.0.0.1:80/alive',
    nagios_service => $nagios_service_name,
    nrdp_folder    => $nrdp_folder,
    require        => Bird::Loopback[$ushers],
  }

  if str2bool($bird_usher_proxy_include) {
    bird::daemon { 'usher_proxy':
      daemontools_ensure => $bird_ensure,
      require            => Twitch_anycast::Health_enforcer::Daemon[$ushers],
    }
  }

  $tags      = prefix($ushers, "nagios_passive_check=${nagios_service_name} ")
  $more_tags = suffix($tags, "|${nagios_service_name}")

  consul::service { 'usher-proxy':
    consul_tags => concat($more_tags, "fqdn=${::fqdn}"),
    port        => 80,
    require     => Twitch_anycast::Health_enforcer::Daemon[$ushers],
  }

  $stats_prefix       = "stats.counters.usher-proxy.${pop}"
  $graphite_endpoint = hiera('graphite_endpoint')

  twitch_nginx::vhost { 'graphite_config':
    content => "graphite_config server=${graphite_endpoint} prefix=${stats_prefix} frequency=10;\n",
  }

}
