# twitch_utils
class twitch_utils {

  require twitch_apt
  include cron
  include twitch_freeipmi_tools
  if $::packer_build_name {
    include twitch_ipmitool
  }

  $text_packages = ['less', 'vim-tiny']

  package { $text_packages:
    ensure => present,
  }

  # apt-utils dialog - stop warning message during interactive shells
  $dpkg_packages = ['apt-utils', 'dialog']
  package { $dpkg_packages:
    ensure => present,
  }


  # dbus - required for systemd utils to communicate with systemd
  $systemd_packages = ['dbus']
  package { $systemd_packages:
    ensure => present,
  }

  $storage_management_packages = [
    'mdadm',
    'lvm2',
  ]

  package { $storage_management_packages:
    ensure  => present,
    require => Package['cron'],
  }

}
