# This class configures video-s3-replication servers in origin DCs.

class twitch_video_s3_replication (
  $env = $twitch_video_s3_replication::params::env,
) inherits twitch_video_s3_replication::params {
  $port = 6091

  # could include the 'video' class for this but we don't actually want most
  # of it, lots of varnish stuff there.
  consul::service { 'video-hls-replication':
    port               => $port,
    consul_tags        => ["fqdn=${::fqdn}", "role-ads", $env],
    maintmode_kv_watch => true,
  }

  # This check is used to determine if this server is up or down.
  # idk if we need this, I just copied it from video::pr
  twitch_nrdp::check { 'server-status':
    command  => '/usr/local/monitor_scripts/check_video_hls_replication_enabled.sh',
    interval => 1,
    retry    => 1,
  }

  class { 'twitch_crashmonitor':
    ensure => 'absent',
  }

  class { 'darkseer': }

  class { 'twitch_nydus':
    ensure => 'present',
    port   => $port,
    binary => 'nydus_ads',
  }
}
