#!/bin/bash
#
#This is a script that runs the first time some one from the
#GSOC connects to the video-tools host.
#This will allow us  to quickly configure the environment

GSOC_STATUS=$(id -nG "$(whoami)" | grep -qw team-gsoc)
retVal=$?

FIRST_TIME=0
INSTALL=0

if [[ $retVal -ne 0 ]]; then
  :
else
  FIRST_TIME=1
fi

if [[ -f ~/.setupcomplete ]]; then
 FIRST_TIME=0
fi


if [[ $FIRST_TIME == 1 ]]; then

	echo "Do you wish to run first time GSOC setup? (enter 1 or 2)"
  select yn in "Yes" "No"; do
      case $yn in
          Yes ) INSTALL=1; break;;
          No ) touch ~/.setupcomplete; break;;
      esac
  done
fi

if [[ $INSTALL == 1 ]]; then
  echo "Hello, please enter your access token, found at https://provisioner.video.xarth.tv/config:"
  read -r -p 'Token: ' provisionertoken

  echo "Hello, please enter your access token, found at https://oauth-broker.prod.vidops.internal.justin.tv/config:"
  read -r -p 'oauth-broker: ' oauthbroker

  echo "Hello, please enter the Kontron (Chassis) Board IP Web Interface (Active Shelf Manager of the Hubnode) via HTTP password found in 1password7:"
  read -r -p 'Kontron (Chassis) Board IP Web Interface (Active Shelf Manager of the Hubnode) via HTTP password: ' kontronipmi

  echo "Hello, please enter your IPMI - Web Console password found in 1password7:"
  read -r -p 'IPMI password: ' ipmipass

  echo "Hello, please enter your Powerserive password found in 1password7:"
  read -r -p 'Powerserive password: ' powerservicepass

  echo "Hello, please enter your Kontron DNS lambda api key PROD found in 1password7:"
  read -r -p 'Kontron API PROD key: ' prodapi

  echo "Hello, please enter your Kontron DNS lambda api key STAGING found in 1password7:"
  read -r -p 'Kontron API STAGING key: ' stagingapi


  mkdir -p "$HOME/.config/provisioner"
  
  cat << EOF > $HOME/.config/provisioner/config
[auth]
access_token = $provisionertoken
ipmi_user = powerservice
ipmi_pass = $powerservicepass

[provisioner]
host = https://api.us-west-2.prod.provisioner.live-video.a2z.com
ipmi_services_host = https://ipmi-services.internal.justin.tv
ipmi_services_api_version = v1
EOF

  touch "$HOME/.bash_profile"

  echo "export PATH=\$PATH:/opt/kontron-infratools/bin
export KONTRONIPMI_PASS=$kontronipmi
export KONTRONAPI_PASS=$kontronipmi
export IPMI_PASS=$ipmipass
export IPMI_PASSWORD=$ipmipass
export POWERSERVICE_PASS=$powerservicepass
export KONTRON_IPMI_USER='admin'
export KONTRON_HUBNODE_IPMI_PASS='admin'
export KONTRON_BUILDSHEET_API_KEY=$prodapi
export KONTRON_BUILDSHEET_API_KEY_STAGING=$stagingapi
export OAUTH_BROKER_TOKEN=$oauthbroker
source ~/.bashrc" >> "$HOME/.bash_profile"

  touch "$HOME/.setupcomplete"

  echo You have completed the first time setup! Please log out and in for the changes to take effect.
  echo If you would like to run it again, remove the .setupcomplete file in your "$HOME" directory.
  echo If you want to manually change any passwords, you can find the files at "$HOME/.bash_ profile"
  echo and "$HOME/.config/provisioner/config"
fi
