#
# GSOC Profile with commonly-used commands for troubleshooting
# Only applies to members of `team-gsoc`
#
GSOC_STATUS=$(id -nG $(whoami) | grep -qw team-gsoc)
retVal=$?

APPLY_PROFILE=0

if [[ $retVal -ne 0 ]]; then
  :
else
  APPLY_PROFILE=1
fi

if [[ -f ~/.no_gsoc_profile ]]; then
  APPLY_PROFILE=0
fi

if [[ $APPLY_PROFILE == 1 ]]; then
  # Common functions are defined below
  drainstatus_f(){ curl https://shimmy.internal.justin.tv/api/v1/validate/drained/$1; echo; }
  drain_f() { curl -X POST -H "Authorization: Bearer $OAUTH_BROKER_TOKEN" --data '{"comment":"'$2'"}' https://shimmy.internal.justin.tv/api/v1/system/disable/$1; echo; }
  undrain_f(){ curl -X POST -H "Authorization: Bearer $OAUTH_BROKER_TOKEN" https://shimmy.internal.justin.tv/api/v1/system/enable/$1; echo; }
  health_f(){ curl -s https://shimmy.internal.justin.tv/api/v1/validate/health/$1; echo; }
  test-stream_f() { echo "https://player.twitch.tv/?channel=${2:-monstercat}&usher_force_segment_node=$1"; }
  pop-capacity_f(){ cappy-cli capacity -p $1 -s $2; }
  pop-total_f(){ cappy-cli limit -p $1 -s $2; }
  ishost-drainable_f(){ cappy-cli drainable -h $1 ; }
  sel_list_f(){ ipmitool -I lanplus -H $1 -U ADMIN -P $IPMI_PASSWORD sel list; }
  preboot_f(){ provision -i $1 -r preboot --target preboot_and_wipe_disks --environment xenial ; }
  gprov_f(){ provision -i $1 -r $2 --environment $3; }
  uidon_f(){ ipmitool -I lanplus -H $1 -U ADMIN -P $IPMI_PASSWORD chassis identify force ; }
  uidoff_f(){ ipmitool -I lanplus -H $1 -U ADMIN -P $IPMI_PASSWORD chassis identify ; }
  power-status_f(){ powercontrol.sh powerstatus $1 ; }
  power-on_f(){ powercontrol.sh poweron $1 ; }
  power-off_f(){ powercontrol.sh poweroff $1 ; }
  power-cycle_f(){ powercontrol.sh powercycle $1 ; }
  # can just cat list-of-hosts | nagios to build a url with all the hosts
  nagios_link_f(){
     BASE_URL="https://nagios.video.xarth.tv/thruk/#cgi-bin/status.cgi?s0_op=~&s0_type=search&add_default_service_filter=1&s0_value="
     while read i; do BASE_URL+="${i}%7C"; done
     echo ${BASE_URL%\%7C}
 }

 brood_delete_f(){
    while read i; do
      IFS='.' read host pop rest <<< "$i"
      printf "removing $host.$pop from brood\n"
      printf "brood-cli node metadata delete --cluster $pop --name $host\n"
      brood-cli node metadata delete --cluster $pop --name $host
    done < $1
 }

 puppet_pdsh_proxy() {
    export PDSH_SSH_ARGS_APPEND="-q -o StrictHostKeyChecking=no"
    export PDSH_RCMD_TYPE=ssh
    pdsh -f 80 -w - ". /etc/profile.d/proxy.sh 2>/dev/null; $@"
 }

  # Aliases are defined below
  alias uidon='uidon_f'
  alias uidoff='uidoff_f'
  alias gprov='gprov_f'
  alias preboot='preboot_f'
  alias sel-list='sel_list_f'
  alias power-status='power-status_f'
  alias power-off='power-off_f'
  alias power-on='power-on_f'
  alias power-cycle='power-cycle_f'
  alias pop-capacity='pop-capacity_f'
  alias pop-total='pop-total_f'
  alias ishost-drainable='ishost-drainable_f'
  alias drain='drain_f'
  alias undrain='undrain_f'
  alias health='health_f'
  alias drainstatus='drainstatus_f'
  alias test-stream='test-stream_f'
  alias nagios='nagios_link_f'
  alias brood-delete='brood_delete_f'
  alias ppdsh="puppet_pdsh_proxy"

fi
