# twitch_video_tools
class twitch_video_tools {
  # class which is loaded on the video tools machines
  # installed packages
  include twitch_ipmitool
  include twitch_freeipmi_tools
  include twitch_motd

  package { 'video-tools-maestro-cli':
    ensure => latest,
  }

  package { 'video-tools-kontron-api':
    ensure => latest,
  }

  package { 'video-tools-provisionercli':
    ensure => latest,
  }

  package { 'video-tools-kontron-tools':
    ensure => latest,
  }

  package { 'kontron-ipmitool':
    ensure => latest,
  }

  package { 'kontron-infratools':
    ensure => latest,
  }

  package { 'symkloudparser':
    ensure => latest,
  }

  package { 'lsconsul':
    ensure => latest,
  }

  package { 'mysql-client':
    ensure => latest,
  }

  package { 'python3-venv':
    ensure => latest,
  }

  package { 'video-tools-kontron-ts':
    ensure => latest,
  }

  package { 'gsoc-cappy-cli':
    ensure => latest,
  }

  package { 'vidops-agnios':
    ensure   => latest,
    provider => 'twitch_pip',
  }

  package { 'video-brood-cli':
    ensure => latest,
  }

  package { 'pdsh':
    ensure => latest,
  }

  twitch_motd::motd_content {'toolsbox-motd':
    content => file("${module_name}/motd"),
  }

  # GSOC Profile with commonly-used commands for troubleshooting
  file { '/etc/profile.d/gsoc_team.sh':
    source => "puppet:///modules/${module_name}/gsoc_team.sh",
    owner  => root,
    group  => root,
    mode   => '0644',
  }

  # GSOC script to setup the environemnt for work
  file { '/etc/profile.d/gsoc_first_time.sh':
    ensure => 'file',
    source => "puppet:///modules/${module_name}/gsoc_first_time.sh",
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }

}
