# twitch_vidops_server module
# runs on the video-ops-* class of servers

class twitch_vidops_server() inherits twitch_vidops_server::params {
  anchor { 'twitch_vidops_server::begin': } ->
  class  { 'twitch_vidops_server::packages': } ->
  class  { 'twitch_vidops_server::configs': } ->
  anchor { 'twitch_vidops_server::end': }

  # keys for dns api oauth
  twitch_sandstorm_agent::template { 'video-ops-dnsapi-id':
    destination => '/opt/twitch/video_ops_dnsapi_id',
    key         => 'video-ops/tools/production/dnsapi_client_id',
  }

  twitch_sandstorm_agent::template { 'video-ops-dnsapi-secret':
    destination => '/opt/twitch/video_ops_dnsapi_secret',
    key         => 'video-ops/tools/production/dnsapi_client_secret',
  }

  twitch_motd::motd_content {'video-ops-motd':
    content => file("${module_name}/motd"),
  }

  twitch_svclogs::logfile { 'echo':
    ensure       => absent,
    use_milliner => false,
  }

  twitch_svclogs::logfile { 'syslog':
    ensure       => absent,
    log_dir      => '/var/log',
    filename     => 'syslog',
    use_milliner => false,
  }

  twitch_svclogs::logfile { 'authlog':
    ensure       => absent,
    log_dir      => '/var/log',
    filename     => 'auth.log',
    account      => 'twitch-video-ops',
    use_milliner => false,
  }

}
