# define packages to install on all video-ops hosts.
class twitch_vidops_server::packages inherits twitch_vidops_server {

  $vidops_server_debs = [
    'video-tools-provisionercli',
    'lsconsul',
    'conman',
    'sandstorm',
    'sipcalc',
    'fakeroot',
    'devscripts',
    'debhelper',
    'golang',
    'irssi',
    'vidops-video-dns',
    'kontron-ipmitool',
  ]

  $vidops_server_gems = [
    'puppet-lint',
  ]

  $vidops_server_pips = [
    'vidops-agnios',
  ]


  package { $vidops_server_debs:
    ensure => latest,
  }

  package { $vidops_server_gems:
    ensure   => latest,
    provider => 'gem',
  }

  package { $vidops_server_pips:
    ensure   => latest,
    provider => 'twitch_pip',
  }

  # remove deb and use gem instead
  exec { 'remove-puppet-lint-deb':
    command => 'apt-get remove -y --purge puppet-lint',
    before  => Package['puppet-lint'],
  }

  # remove deb and use deb instead
  package { 'provisionercli-pip':
    ensure   => absent,
    name     => 'provisionercli',
    provider => 'twitch_pip',
    before   => Package['video-tools-provisionercli'],
  }


}
